package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Itree of an args passing in the form {@code [:X [:A :B] :Y] <- \args}.
 *
 * @param params the params.
 * @param pos    the pos index of the itree.
 */
public record NestedArgsPassingItree(List<NestedParam> params,
                                     int pos) implements Itree {

    /**
     * Constructs an itree.
     *
     * @param params the params.
     * @param pos    the pos index of the itree.
     */
    public NestedArgsPassingItree {
        params = List.copyOf(params);
    }

    /**
     * Returns the representation of the left-hand-side.
     *
     * @return the representation of the left-hand-side.
     */
    public String lhsRepr() {
        return params().stream()
            .map(p -> p.lhsRepr())
            .collect(Collectors.joining(" ", "[", "]"));
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
