package org.kink_lang.kink.internal.program.itree;

/**
 * Itree of nonlocal var assignment such as {@code B:X <- 42}.
 *
 * @param owner the owner of the var.
 * @param sym   the sym of the var.
 * @param rhs   the right hand side of the assignment.
 * @param pos   the pos of the assignment.
 */
public record StoreItree(Itree owner, String sym,
                         Itree rhs, int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
