package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * A fun call which is not a method call,
 * and has a sym.
 *
 * @param fun  the fun to be called.
 * @param sym  the sym of the call.
 * @param recv the actual recv of the call.
 * @param args the actual args of the call.
 * @param pos  the pos of the call.
 */
public record SymcallItree(Itree fun, String sym,
                           Itree recv,
                           List<ItreeElem> args,
                           int pos) implements Itree {

    /**
     * Constructs an itree.
     *
     * @param fun  the fun to be called.
     * @param sym  the sym of the call.
     * @param recv the actual recv of the call.
     * @param args the actual args of the call.
     * @param pos  the pos of the call.
     */
    public SymcallItree {
        args = List.copyOf(args);
    }

    /**
     * Returns whether the call is a call of a local fun.
     *
     * @param sym the sym to be tested.
     * @return whether the call is a call of a local fun.
     */
    public boolean isLocalCallOf(String sym) {
        return fun() instanceof LderefItree
                && ((LderefItree) fun()).lvar().name().equals(sym)
                && sym().equals(sym)
                && recv() instanceof NadaItree;
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
