package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Assignment in the form {@code [:Foo X:Bar] <- Rhs}.
 *
 * @param params the varref params of the lhs.
 * @param rhs    the right-hand-side of the assignment.
 * @param pos    the pos index of the assignment.
 */
public record VarrefVecAssignmentItree(List<VarrefParam> params,
                                       Itree rhs, int pos) implements Itree {

    /**
     * Constructs an assignment.
     *
     * @param params the varref params of the lhs.
     * @param rhs    the right-hand-side of the assignment.
     * @param pos    the pos index of the assignment.
     */
    public VarrefVecAssignmentItree {
        params = List.copyOf(params);
    }

    /**
     * Returns the string representation of the left hand side.
     *
     * @return the string representation of the left hand side.
     */
    public String lhsRepr() {
        return params().stream()
            .map(VarrefParam::lhsRepr)
            .collect(Collectors.joining(" ", "[", "]"));
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
