package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * A vec itree.
 *
 * @param elems the elems of the vec.
 * @param pos   the pos of the itree on the program text.
 */
public record VecItree(List<ItreeElem> elems,
                       int pos) implements Itree {

    /**
     * Constructs a vec itree.
     *
     * @param elems the elems of the vec.
     * @param pos   the pos of the itree on the program text.
     */
    public VecItree {
        elems = List.copyOf(elems);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
