package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Optimizes bi arithmetic operations to BiArithmeticItree..
 */
public class BiArithmeticInliner extends BaseOptimizer {

    @Override
    public Itree visit(McallItree mcall) {
        BiArithmeticItree.Op op;
        switch (mcall.sym()) {
            case "op_add": {
                op = BiArithmeticItree.Op.ADD;
                break;
            }
            case "op_sub": {
                op = BiArithmeticItree.Op.SUB;
                break;
            }
            case "op_mul": {
                op = BiArithmeticItree.Op.MUL;
                break;
            }
            default: {
                return mcall;
            }
        }

        List<ItreeElem> args = mcall.args();
        if (args.size() != 1 || args.get(0).isSpread()) {
            return mcall;
        }

        Itree arg = args.get(0).expr();
        if (! (arg instanceof NumItree)) {
            return mcall;
        }

        NumItree argNum = (NumItree) arg;
        return new BiArithmeticItree(
                mcall.ownerRecv(),
                op,
                argNum.num(),
                mcall.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
