package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.Optional;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Inlining optimizer of preloaded {@code if}.
 */
public class IfInliner extends BaseOptimizer {

    @Override
    public Itree visit(SymcallItree scall) {
        if (! scall.isLocalCallOf("if")) {
            return scall;
        }

        if (scall.args().stream().anyMatch(ItreeElem::isSpread)) {
            return scall;
        }

        List<Itree> args = scall.args().stream().map(ItreeElem::expr).toList();
        if (args.size() < 2 || args.size() > 3) {
            return scall;
        }

        Itree cond = args.get(0);

        if (! isContFun(args.get(1))) {
            return scall;
        }
        FastFunItree trueCont = (FastFunItree) args.get(1);

        if (scall.args().size() == 2) {
            return new IfItree(cond, trueCont, Optional.empty(), scall.pos());
        }

        if (! isContFun(args.get(2))) {
            return scall;
        }
        FastFunItree falseCont = (FastFunItree) args.get(2);
        return new IfItree(cond, trueCont, Optional.of(falseCont), scall.pos());
    }

    /**
     * Whether the arg is a valid continuation fun.
     */
    private boolean isContFun(Itree itree) {
        return itree instanceof FastFunItree fun
            && ! RecvArgsSearcher.containsRecvOrArgs(fun.body());
    }

}

// vim: et sw=4 sts=4 fdm=marker
