package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Converts {@code :foo <- { ,,, }} to letrec.
 *
 * <p>This optimizer must not be used within IndexFunItree.
 * Because if an assignment in IndexFunItree is in the form above,
 * it is already a result by LetInliner,
 * and thus the rhs fun must not capture the lvar in the lhs recursively.</p>
 */
public class LetRecProducer extends BaseOptimizer {

    @Override
    public Itree visit(LstoreItree lstore) {
        Itree rhs = lstore.rhs();
        if (! (rhs instanceof FastFunItree fun)) {
            return lstore;
        }

        LocalVar lvar = lstore.lvar();
        LetRecItree.LvarFunPair pair = new LetRecItree.LvarFunPair(lvar, fun);
        return new LetRecItree(List.of(pair), lstore.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
