package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Applies constant folding for expressions in the form
 * {@code - NUM_CONST}.
 */
public class MinusConstantFolder extends BaseOptimizer {

    @Override
    public Itree visit(McallItree mcall) {
        if (! mcall.sym().equals("op_minus")
                || ! (mcall.ownerRecv() instanceof NumItree)
                || ! mcall.args().isEmpty()) {
            return mcall;
        }

        NumItree num = (NumItree) mcall.ownerRecv();
        return new NumItree(num.num().negate(), num.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
