package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.OptVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;

/**
 * Optimizes assignment in the form {@code [:A :B :C.opt :D.opt] <- xxx}.
 */
public class OptVecAssignmentOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(AssignmentItree assignment) {
        Itree lhs = assignment.lhs();
        if (! (lhs instanceof VecItree)) {
            return assignment;
        }

        VecItree lhsVec = (VecItree) lhs;
        List<ItreeElem> args = lhsVec.elems();

        // [:A :B ,,,]
        List<LocalVar> mandatory = args.stream().takeWhile(Params::isMandatoryParam)
            .map(Params::getMandatoryParamSym)
            .map(name -> (LocalVar) new LocalVar.Original(name))
            .toList();

        // [,,, :C.opt :D.opt]
        List<ItreeElem> expOptParams = args.subList(mandatory.size(), args.size());
        if (! expOptParams.stream().allMatch(Params::isOptParam)) {
            return assignment;
        }
        List<LocalVar> opt = expOptParams.stream()
            .map(Params::getOptParamSym)
            .map(name -> (LocalVar) new LocalVar.Original(name))
            .toList();

        return new OptVecAssignmentItree(
                mandatory,
                opt,
                assignment.rhs(), assignment.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
