package org.kink_lang.kink.internal.program.itreeoptimize;

import java.io.Serial;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Operations on itrees.
 */
final class RecvArgsSearcher {

    /**
     * Should not be instantiated.
     */
    private RecvArgsSearcher() {
    }

    /**
     * Returns whether itree contains the recv or the args.
     */
    static boolean containsRecvOrArgs(Itree itree) {
        try {
            DeepTransformer.deepTransform(itree, new Callback());
        } catch (ContainsRecvOrArgsException croae) {
            return true;
        }
        return false;
    }

    /**
     * Callback for analysis.
     */
    static class Callback implements DeepTransformer.Callback {

        @Override
        public LocalVar derefLvar(LocalVar lvar) {
            return lvar;
        }

        @Override
        public LocalVar storeLvar(LocalVar lvar) {
            return lvar;
        }

        @Override
        public Itree itree(Itree itree) {
            if (itree instanceof ArgVecItree
                    || itree instanceof RecvItree
                    || itree instanceof ArgsPassingItree
                    || itree instanceof NestedArgsPassingItree) {
                throw new ContainsRecvOrArgsException();
            }
            return itree;
        }

    }

    /**
     * Exception thrown when the recv or the args is found.
     */
    private static class ContainsRecvOrArgsException extends RuntimeException {

        /** Serial version UID. */
        @Serial
        private static final long serialVersionUID = -6000449951574844049L;

    }

}

// vim: et sw=4 sts=4 fdm=marker
