package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.StrItree;

/**
 * Optimizes invocation in the form {@code new_val('X' x 'Y' y)}.
 */
public class SimpleNewValInliner extends BaseOptimizer {

    @Override
    public Itree visit(SymcallItree scall) {
        if (! scall.isLocalCallOf("new_val")) {
            return scall;
        }

        List<ItreeElem> argElems = scall.args();
        if (! argElems.stream().allMatch(ItreeElem::isSingle)) {
            return scall;
        }

        List<Itree> args = argElems.stream().map(ItreeElem::expr).toList();
        if (args.size() % 2 != 0) {
            return scall;
        }

        List<SymValPair> symValPairs = new ArrayList<>();
        for (int i = 0; i < args.size(); i += 2) {
            Itree symItree = args.get(i);
            if (! (symItree instanceof StrItree sym)) {
                return scall;
            }
            Itree val = args.get(i + 1);
            symValPairs.add(new SymValPair(sym.str(), val));
        }

        return new NoTraitNewValItree(symValPairs, scall.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
