package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.kink_lang.kink.internal.program.itree.ArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.NestedArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.NestedParam;

/**
 * Converts nested args passing to unnested one.
 */
public class UnnestArgsPassingOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(NestedArgsPassingItree itree) {
        int pos = itree.pos();
        return extractUnnestedLvars(itree.params())
            .map(lvars -> (Itree) new ArgsPassingItree(lvars, pos))
            .orElse(itree);
    }

    /**
     * Extract syms only when all the params are unnested.
     */
    private Optional<List<LocalVar>> extractUnnestedLvars(List<NestedParam> params) {
        List<LocalVar> lvars = new ArrayList<>();
        for (NestedParam param : params) {
            if (param instanceof LocalVar lp) {
                lvars.add(lp);
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(lvars);
    }

}

// vim: et sw=4 sts=4 fdm=marker
