package org.kink_lang.kink.internal.program.lex;

/**
 * A special token which indicates the end-of-text.
 *
 * <p>The token is always on the end of the program text, and is zero-width.
 * Thus getTextLength, getStartPos, and getEndPos always the return equal value.</p>
 *
 * @param textLength the length of the program text.
 */
public record EotToken(int textLength) implements Token {

    @Override
    public int startPos() {
        return textLength();
    }

    @Override
    public int endPos() {
        return textLength();
    }

}

// vim: et sw=4 sts=4 fdm=marker
