package org.kink_lang.kink.internal.vec;

import org.kink_lang.kink.Val;

/**
 * Error that the vec cannot be treated as a trait.
 */
public sealed interface TraitError extends MaybeTrait {

    /**
     * The arity is not even, so the vec cannot be a trait.
     *
     * @param arity the number of elems.
     */
    record ArityNotEven(int arity) implements TraitError {}

    /**
     * The elem specified by the index is not a str.
     *
     * @param index the index of the elem.
     * @param elem the val at the specified index.
     */
    record SymNotStr(int index, Val elem) implements TraitError {}

}

// vim: et sw=4 sts=4 fdm=marker
