/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.hostfun.graph.impl;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.function.ThrowingFunction2;

class ArgsCollector {
    private final GraphNode[] args;

    ArgsCollector(GraphNode[] args) {
        this.args = args;
    }

    HostResult collectArgs(HostContext c, ThrowingFunction2<HostContext, Val[], HostResult> handler) throws Throwable {
        return this.collectArgsLoop(c, List.of(), handler);
    }

    private HostResult collectArgsLoop(HostContext c, List<Val> collectedVals, ThrowingFunction2<HostContext, Val[], HostResult> handler) throws Throwable {
        if (collectedVals.size() == this.args.length) {
            Val[] argVals = collectedVals.toArray(new Val[0]);
            return handler.apply(c, argVals);
        }
        GraphNode argGraph = this.args[collectedVals.size()];
        return c.call(argGraph).on((cc, argVal) -> {
            ArrayList<Val> newVals = new ArrayList<Val>(collectedVals.size() + 1);
            newVals.addAll(collectedVals);
            newVals.add(argVal);
            return this.collectArgsLoop(cc, newVals, handler);
        });
    }
}

