/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.bootstrap;

import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.Vm;

final class NumRegistry {
    private final Vm vm;
    private final ConcurrentMap<BigDecimal, NumVal> map = new ConcurrentHashMap<BigDecimal, NumVal>();

    private NumRegistry(Vm vm) {
        this.vm = vm;
    }

    static NumVal numVal(Vm vm, BigDecimal decimal) {
        NumRegistry registry = vm.component.getOrRegister(NumRegistry.class, NumRegistry::new);
        return registry.numVal(decimal);
    }

    private NumVal numVal(BigDecimal decimal) {
        return this.map.computeIfAbsent(decimal, this::makeNumVal);
    }

    private NumVal makeNumVal(BigDecimal decimal) {
        if (decimal.scale() == 0) {
            try {
                return this.vm.num.of(decimal.longValueExact());
            }
            catch (ArithmeticException ex) {
                return this.vm.num.of(decimal);
            }
        }
        return this.vm.num.of(decimal);
    }
}

