/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.classgen;

import java.util.List;
import java.util.Map;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.javaclassir.BytecodeGenState;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class BytecodeGenerator {
    private static final String BASE_CLASS_NAME = "org/kink_lang/kink/GeneratedFunValBase";

    public byte[] generate(JavaClassIr jcir) {
        ClassWriter cw = new ClassWriter(2);
        cw.visit(61, 0, JavaClassIr.TYPE_BASE.getInternalName(), null, BASE_CLASS_NAME, null);
        this.genTraceMapField(cw);
        this.genVmStaticField(cw);
        this.genChildJcirFactoriesField(cw);
        this.genValFields(cw, jcir.valFieldCount());
        this.genConstructor(cw, jcir.valFieldCount());
        this.genDoResume(cw, jcir.doResumeInsns());
        this.genDesc(cw, jcir.desc());
        this.genDataStackUsageUpperBound(cw, jcir.dataStackUsageUpperBound());
        this.genTrace(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void genTraceMapField(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(74, "traceMap", Type.getDescriptor(Map.class), null, null);
        fv.visitEnd();
    }

    private void genChildJcirFactoriesField(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(73, "childJcirFactories", Type.getDescriptor(List.class), null, null);
        fv.visitEnd();
    }

    private void genVmStaticField(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(74, "vmStatic", Type.getDescriptor(Vm.class), null, null);
        fv.visitEnd();
    }

    private void genValFields(ClassWriter cw, int valFieldCount) {
        for (int i = 0; i < valFieldCount; ++i) {
            FieldVisitor fv = cw.visitField(18, BytecodeGenerator.valFieldName(i), Type.getDescriptor(Val.class), null, null);
            fv.visitEnd();
        }
    }

    private void genConstructor(ClassWriter cw, int valFieldCount) {
        Type[] paramTypes = new Type[valFieldCount + 1];
        paramTypes[0] = Type.getType(Vm.class);
        for (int i = 0; i < valFieldCount; ++i) {
            paramTypes[i + 1] = Type.getType(Val.class);
        }
        Method m = new Method("<init>", Type.VOID_TYPE, paramTypes);
        GeneratorAdapter mg = new GeneratorAdapter(2, m, null, null, (ClassVisitor)cw);
        mg.loadThis();
        mg.loadArg(0);
        mg.invokeConstructor(Type.getType((String)"Lorg/kink_lang/kink/GeneratedFunValBase;"), new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Vm.class)}));
        for (int i = 0; i < valFieldCount; ++i) {
            mg.loadThis();
            mg.loadArg(i + 1);
            mg.putField(JavaClassIr.TYPE_BASE, BytecodeGenerator.valFieldName(i), Type.getType(Val.class));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private static String valFieldName(int index) {
        return "valField" + index;
    }

    private void genDoResume(ClassWriter cw, List<Insn> doResumeInsns) {
        Method m = new Method("doResume", Type.VOID_TYPE, new Type[]{Type.getType((String)"Lorg/kink_lang/kink/StackMachine;"), Type.getType((String)"Lorg/kink_lang/kink/Val;"), Type.INT_TYPE, Type.getType((String)"Lorg/kink_lang/kink/internal/callstack/CallStack;"), Type.getType((String)"Lorg/kink_lang/kink/DataStack;"), Type.INT_TYPE});
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        BytecodeGenState state = new BytecodeGenState(mg, doResumeInsns);
        doResumeInsns.forEach(insn -> insn.generateBytecodeSnippet(state));
        mg.endMethod();
    }

    private void genDesc(ClassWriter cw, String desc) {
        Method m = new Method("desc", Type.getType(String.class), new Type[0]);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        mg.push(desc);
        mg.returnValue();
        mg.endMethod();
    }

    private void genDataStackUsageUpperBound(ClassWriter cw, int dataStackUsageUpperBound) {
        Method m = new Method("dataStackUsageUpperBound", Type.getType(Integer.TYPE), new Type[0]);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        mg.push(dataStackUsageUpperBound);
        mg.returnValue();
        mg.endMethod();
    }

    private void genTrace(ClassWriter cw) {
        Method m = new Method("trace", Type.getType(Trace.class), new Type[]{Type.getType(Integer.TYPE)});
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        mg.getStatic(JavaClassIr.TYPE_BASE, "traceMap", Type.getType(Map.class));
        mg.loadArg(0);
        mg.box(Type.getType(Integer.TYPE));
        mg.invokeInterface(Type.getType(Map.class), new Method("get", Type.getType(Object.class), new Type[]{Type.getType(Object.class)}));
        mg.checkCast(Type.getType(Trace.class));
        mg.returnValue();
        mg.endMethod();
    }
}

