/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.str;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.kink_lang.kink.internal.contract.Preconds;

public class Decoder {
    private final CharsetDecoder csDecoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private boolean isTerminated = false;

    Decoder(CharsetDecoder csDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
        this.csDecoder = csDecoder;
        this.byteBuffer = byteBuffer;
        this.charBuffer = charBuffer;
    }

    public static Decoder of(Charset cs) {
        CharsetDecoder csDecoder = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        CharBuffer charBuffer = CharBuffer.wrap(new char[100]);
        return new Decoder(csDecoder, byteBuffer, charBuffer);
    }

    public void terminate() {
        Preconds.checkState(!this.isTerminated(), "must not be terminated twice");
        this.isTerminated = true;
        this.byteBuffer.flip();
        this.ensureCharsCapa(this.byteBuffer.limit());
        this.csDecoder.decode(this.byteBuffer, this.charBuffer, true);
        this.csDecoder.flush(this.charBuffer);
        this.byteBuffer.compact();
    }

    boolean isTerminated() {
        return this.isTerminated;
    }

    public void consume(byte[] bytes) {
        this.ensureBytesCapa(bytes.length);
        this.byteBuffer.put(bytes);
        this.byteBuffer.flip();
        this.ensureCharsCapa(this.byteBuffer.limit());
        this.csDecoder.decode(this.byteBuffer, this.charBuffer, false);
        this.byteBuffer.compact();
    }

    private void ensureBytesCapa(int addedBytesLen) {
        if (addedBytesLen <= this.byteBuffer.remaining()) {
            return;
        }
        int newCapa = (this.byteBuffer.position() + addedBytesLen) * 2;
        ByteBuffer newBytes = ByteBuffer.allocate(newCapa);
        this.byteBuffer.flip();
        newBytes.put(this.byteBuffer);
        this.byteBuffer = newBytes;
    }

    private void ensureCharsCapa(int addedBytesLen) {
        int maxCharsAdded = (int)Math.ceil(this.csDecoder.maxCharsPerByte()) * addedBytesLen;
        if (maxCharsAdded <= this.charBuffer.remaining()) {
            return;
        }
        int newCapa = this.charBuffer.position() + maxCharsAdded;
        CharBuffer newChars = CharBuffer.wrap(new char[newCapa]);
        this.charBuffer.flip();
        newChars.put(this.charBuffer);
        this.charBuffer = newChars;
    }

    public String emitText() {
        this.charBuffer.flip();
        int endPos = Decoder.endPosOfAvailableText(this.charBuffer);
        String result = this.charBuffer.subSequence(0, endPos).toString();
        this.charBuffer.position(endPos);
        this.charBuffer.compact();
        return result;
    }

    private static int endPosOfAvailableText(CharSequence chars) {
        int len = chars.length();
        return len >= 1 && Character.isHighSurrogate(chars.charAt(len - 1)) ? len - 1 : len;
    }
}

