package org.kink_lang.kink;

/**
 * The bidirectional registry of syms and sym-handles.
 */
public interface SymRegistry {

    /**
     * Registers or gets the handle of the sym.
     *
     * @param sym the sym.
     * @return the handle.
     * @throws IllegalStateException
     *      if the sym is not registered yet,
     *      and the registry does not have capacity for the new sym.
     */
    int handleFor(String sym);

    /**
     * Returns the corresponding sym for the handle.
     *
     * @param handle the handle.
     * @return the corresponding sym for the handle.
     * @throws IllegalArgumentException if the specified handle is not registered.
     */
    String symFor(int handle);

    /**
     * Returns true if the handle is registered.
     *
     * @param handle the handle.
     * @return true if the handle is registered.
     */
    boolean isValidHandle(int handle);

}

// vim: et sw=4 sts=4
