package org.kink_lang.kink;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import javax.annotation.Nullable;

import org.kink_lang.kink.internal.vec.MaybeTrait;
import org.kink_lang.kink.internal.vec.TraitVecInternal;
import org.kink_lang.kink.internal.vec.VecInternal;

/**
 * A vec val.
 */
public class VecVal extends Val {

    /** The vec internal containing the elements. */
    private VecInternal vecInternal;

    /**
     * Constructs a vec val.
     */
    VecVal(Vm vm, VecInternal vecInternal) {
        super(vm, null);
        this.vecInternal = vecInternal;
    }

    /**
     * Returns a list containing the elements of the vec.
     *
     * <p>The result list may or may not reflect modification
     * after returning from the method.</p>
     *
     * @return a list containing the elements of the vec.
     */
    public List<Val> toList() {
        return this.vecInternal.asList();
    }

    /**
     * Returns the backing vecInternal.
     */
    VecInternal vecInternal() {
        return this.vecInternal;
    }

    /**
     * Sets the backing vecInternal.
     */
    void setVecInternal(VecInternal vecInternal) {
        this.vecInternal = vecInternal;
    }

    /**
     * Returns the trait vec internal of this vec if possible;
     * otherwise null.
     *
     * @return the trait vec internal of this vec if possible, or null.
     */
    @Nullable
    MaybeTrait getTrait() {
        MaybeTrait maybeTrait = this.vecInternal.getTrait();
        if (! (maybeTrait instanceof TraitVecInternal tvi)) {
            return maybeTrait;
        }

        setVecInternal(tvi);
        return tvi;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "VecVal(%s)", toList());
    }

    /**
     * Returns properties which determine equality of the val type.
     */
    private List<Object> properties() {
        return Arrays.asList(this.vm, toList());
    }

    @Override
    public int hashCode() {
        return properties().hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        return arg == this
            || arg instanceof VecVal argVec
            && properties().equals(argVec.properties());
    }

    @Override
    SharedVars sharedVars() {
        return vm.vec.sharedVars;
    }

}

// vim: et sw=4 sts=4 fdm=marker
