package org.kink_lang.kink.hostfun;

/**
 * Call flow step to bind a return val handler.
 *
 * <p>If an instance of this interface is returned as the result of
 * the host fun action,
 * the fun is called as a tail call.</p>
 *
 * <p>If you want to use the result of the fun call,
 * provide a handler via {@link #on(HostFunReaction)}.</p>
 */
public interface CallFlowToOn extends HostResult {

    /**
     * Makes a non-tail call HostResult which continues to the handler
     * when the fun call returns the result.
     *
     * @param reaction the handler of the return val.
     * @return a non-tail call result.
     */
    public abstract HostResult on(HostFunReaction reaction);

}

// vim: et sw=4 sts=4 fdm=marker
