package org.kink_lang.kink.hostfun.graph;

import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;

/**
 * The type of an execution graph node.
 *
 * <p>See {@link org.kink_lang.kink.hostfun.graph} for usage.</p>
 */
public interface GraphNode {

    /**
     * Evaluates the execution graph in the context.
     *
     * <p>Use {@link org.kink_lang.kink.hostfun.HostContext#call(GraphNode)}
     * instead of calling this method directly.</p>
     *
     * @param c the context of the host fun action.
     * @return the HostResult to evaluate the graph.
     * @throws Throwable thrown during evaluation.
     */
    public abstract HostResult evaluateIn(HostContext c) throws Throwable;

}

// vim: et sw=4 sts=4 fdm=marker
