package org.kink_lang.kink.hostfun.graph.impl;

import java.util.ArrayList;
import java.util.List;

import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.hostfun.graph.GraphNode;

/**
 * Helper class to collect args from the graph nodes.
 */
class ArgsCollector {

    /** The graph nodes of the args. */
    private final GraphNode[] args;

    /**
     * Constructs a collector.
     */
    ArgsCollector(GraphNode[] args) {
        this.args = args;
    }

    /**
     * Collects args and emits to the handler.
     * @param c
     * @param handler
     */
    HostResult collectArgs(
            HostContext c,
            ThrowingFunction2<HostContext, Val[], HostResult> handler
            ) throws Throwable {
        return collectArgsLoop(c, List.of(), handler);
    }

    /**
     * Loop of collectArgs.
     */
    private HostResult collectArgsLoop(
            HostContext c,
            List<Val> collectedVals,
            ThrowingFunction2<HostContext, Val[], HostResult> handler
            ) throws Throwable {
        if (collectedVals.size() == args.length) {
            Val[] argVals = collectedVals.toArray(new Val[0]);
            return handler.apply(c, argVals);
        }

        GraphNode argGraph = args[collectedVals.size()];
        return c.call(argGraph).on((cc, argVal) -> {
            List<Val> newVals = new ArrayList<>(collectedVals.size() + 1);
            newVals.addAll(collectedVals);
            newVals.add(argVal);
            return collectArgsLoop(cc, newVals, handler);
        });
    }

}

// vim: et sw=4 sts=4 fdm=marker
