package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToArgs;
import org.kink_lang.kink.hostfun.graph.GraphNode;

/**
 * Call graph in the form of SOME_MOD.some_fun(,,,).
 */
class ModCallGraph implements CallGraphNodeToArgs {

    /** The vm. */
    private final Vm vm;

    /** The name of the mod. */
    private final String modName;

    /** The sym handle of the fun. */
    private final int symHandle;

    /** The graph nodes of the args. */
    private final GraphNode[] args;

    /**
     * Constructs a mod call graph.
     */
    ModCallGraph(Vm vm, String modName, int symHandle, GraphNode[] args) {
        this.vm = vm;
        this.modName = modName;
        this.symHandle = symHandle;
        this.args = args;
    }

    @Override
    public HostResult evaluateIn(HostContext c) throws Throwable {
        return new ArgsCollector(args).collectArgs(c,
                (cc, argVals) -> cc.call(modName, symHandle).args(argVals));
    }

    @Override
    public GraphNode args(GraphNode... args) {
        return new ModCallGraph(this.vm, this.modName, this.symHandle, args);
    }

}

// vim: et sw=4 sts=4 fdm=marker
