/**
 * Provides the Execution Graph DSL,
 * which is a convenient way to invoke Kink funs from Java actions or handlers.
 *
 * <p>Without the DSL, it can easily become cumbersome to invoke a Kink fun
 * using results of other invocations.
 * For exmaple, tail-calling of {@code (X + Y) * (Z + W)} from a Java make is
 * written as:</p>
 *
 * <pre>
 *  Val x = ,,, y = ,,, z = ,,, w  = ,,,
 *  int add = vm.sym.getHandle("op_add");
 *  int mul = vm.sym.getHandle("op_mul");
 *  return c.call(x, add).args(y).on((cc, xy) -&gt; {
 *      return cc.call(z, add).args(w).on((c3, zw) -&gt; {
 *          return c3.call(xy, mul).args(zw);
 *      });
 *  });
 * </pre>
 *
 * <p>Using the Execution Graph DSL,
 * you can write the equivalent Java code
 * without nesting lambdas and multiple call contexts:</p>
 *
 * <pre>
 *  Val x = ,,, y = ,,, z = ,,, w  = ,,,
 *  int add = vm.sym.getHandle("op_add");
 *  int mul = vm.sym.getHandle("op_mul");
 *  GraphNode xPlusY = vm.graph.call(vm.graph.of(x), add).args(vm.graph.of(y));
 *  GraphNode zPlusW = vm.graph.call(vm.graph.of(z), add).args(vm.graph.of(w));
 *  GraphNode result = vm.graph.call(xPlusY, mul).args(zPlusW);
 *  return c.call(result);
 * </pre>
 *
 * <p>There are also shorthands for several idioms
 * such as {@code raise(Template.format(,,,))} or {@code Val.repr}.</p>
 *
 * <pre>
 *  return c.call(vm.graph.raiseFormat(
 *      "expected a str, but got {}",
 *      vm.graph.repr(arg)));
 * </pre>
 *
 * @see org.kink_lang.kink.Vm#graph
 */
package org.kink_lang.kink.hostfun.graph;

// vim: et sw=4 sts=4 fdm=marker
