package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;

/**
 * Accumulates child JavaClassIr instances.
 */
public class ChildJcirAccumulator {

    /** The factories of child jcirs. */
    private final List<JcirFactory> childJcirFactories = new ArrayList<>();

    /**
     * Adds the jcir factory and retunrs the index of the added.
     *
     * @param jcirFactory the jcir factory to add.
     * @return the index of the added jcir factory.
     */
    public int add(JcirFactory jcirFactory) {
        int ind = this.childJcirFactories.size();
        this.childJcirFactories.add(jcirFactory);
        return ind;
    }

    /**
     * Returns the factories of child jcirs.
     *
     * @return the factories of child jcirs.
     */
    public List<JcirFactory> childJcirFactories() {
        return List.copyOf(this.childJcirFactories);
    }

}

// vim: et sw=4 sts=4 fdm=marker
