package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.List;
import java.util.function.BiFunction;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LetRecItree;

/**
 * Generates letrec.
 */
public interface LetRecGenerator {

    /**
     * Generates letrec insns.
     *
     * @param itree letrec itree.
     * @param generate generates insns of sub expressions.
     * @return insns.
     */
    List<Insn> letRec(
            LetRecItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate);

}

// vim: et sw=4 sts=4 fdm=marker
