package org.kink_lang.kink.internal.compile.tempval;

import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.vec.MaybeTrait;

/**
 * Internal temporary val to store MaybeTrait.
 */
public class MaybeTraitVal extends Val {

    /** The stored MaybeTrait. */
    private final MaybeTrait maybeTrait;

    /**
     * Constructs a temporary val.
     *
     * @param vm the vm.
     * @param maybeTrait the MaybeTrait to store.
     */
    public MaybeTraitVal(Vm vm, MaybeTrait maybeTrait) {
        super(vm);
        this.maybeTrait = maybeTrait;
    }

    /**
     * Returns the stored MaybeTrait.
     *
     * @return the stored MaybeTrait.
     */
    public MaybeTrait getMaybeTrait() {
        return this.maybeTrait;
    }

}

// vim: et sw=4 sts=4 fdm=marker
