package org.kink_lang.kink.internal.mod.java;

import javax.annotation.Nullable;

import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;

/**
 * Factory of PROXY_THROW_RESULT mod.
 */
public class ProxyThrowResultMod {

    /** The vm. */
    private final Vm vm;

    /** The name of the mod. */
    public static final String MOD_NAME = "kink/javahost/PROXY_THROW_RESULT";

    /**
     * Constructs the factory.
     */
    private ProxyThrowResultMod(Vm vm) {
        this.vm = vm;
    }

    /**
     * Makes PROXY_THROW_RESULT mod in the vm.
     *
     * @param vm the vm.
     * @return PROXY_THROW_RESULT mod.
     */
    public static Val makeMod(Vm vm) {
        return new ProxyThrowResultMod(vm).makeMod();
    }

    /**
     * Maks a mod.
     */
    private Val makeMod() {
        Val mod = vm.newVal();
        mod.setVar(vm.sym.handleFor("new"),
                vm.fun.make("PROXY_THROW_RESULT.new(Exception_java_val)")
                .take(1).action(this::newFun));
        mod.setVar(vm.sym.handleFor("is?"),
                vm.fun.make("PROXY_THROW_RESULT.is?(Val)").take(1).action(this::isPFun));
        return mod;
    }

    /**
     * Implementation of PROXY_THROW_RESULT.new.
     */
    private HostResult newFun(CallContext c) {
        Throwable th = extractThrowable(c.arg(0));
        if (th == null) {
            String desc = "PROXY_THROW_RESULT.new(Exception_java_val)";
            return c.call(vm.graph.raiseFormat(
                        "{}: the arg must be a java val of a Throwable, but got {}",
                        vm.graph.of(vm.str.of(desc)),
                        vm.graph.repr(c.arg(0))));
        }
        return ProxyThrowResultVal.of(vm, th);
    }

    /**
     * Extracts a Throwable instance from arg,
     * or null if it is not an appropriate java val.
     */
    @Nullable
    private Throwable extractThrowable(Val arg) {
        if (! (arg instanceof JavaVal excJavaVal)) {
            return null;
        }
        if (! (excJavaVal.objectReference() instanceof Throwable th)) {
            return null;
        }
        return th;
    }

    /**
     * Implementation of PROXY_THROW_RESULT.is?.
     */
    private HostResult isPFun(CallContext c) {
        return vm.bool.of(c.arg(0) instanceof ProxyThrowResultVal);
    }

}

// vim: et sw=4 sts=4 fdm=marker
