package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * Invocation of branch in the following form.
 *
 * <pre>
 * branch(
 *   { cond1 } { then1 }
 *   { cond2 } { then2 }
 *   { cond3 } { then3 }
 * )
 * </pre>
 *
 * @param condThenPairs cond-then pairs.
 * @param pos the pos index of this itree.
 */
public record BranchItree(List<CondThenPair> condThenPairs, int pos) implements Itree {

    /**
     * Makes a branch invocation itree without an else block.
     *
     * @param condThenPairs cond-then pairs.
     * @param pos the pos index of this itree.
     */
    public BranchItree {
        condThenPairs = List.copyOf(condThenPairs);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
