package org.kink_lang.kink.internal.program.itree;

/**
 * An elem of vec bodies or actual args.
 */
public sealed interface ItreeElem permits ItreeElem.Spread, Itree {

    /**
     * ItreeElem of SPREAD type.
     *
     * @param expr the expression in the elem.
     * @param pos the pos of the elem on the program text.
     */
    record Spread(Itree expr, int pos) implements ItreeElem {
        @Override public boolean isSingle() {
            return false;
        }
    }

    /**
     * Returns whether the type is SINGLE.
     *
     * @return whether the type is SINGLE.
     */
    boolean isSingle();

    /**
     * Returns whether the type is SPREAD.
     *
     * @return whether the type is SPREAD.
     */
    default boolean isSpread() {
        return ! isSingle();
    }

    /**
     * Returns the expression in the elem.
     *
     * @return the expression in the elem.
     */
    Itree expr();

    /**
     * Returns the pos of the elem on the program text.
     *
     * @return the pos of the elem on the program text.
     */
    int pos();

}

// vim: et sw=4 sts=4 fdm=marker
