package org.kink_lang.kink.internal.program.itree;

/**
 * Itree of local var assignment such as {@code :X <- 42}.
 *
 * @param lvar the local var.
 * @param rhs the right hand side of the assignment.
 * @param pos the pos of the assignment.
 */
public record LstoreItree(LocalVar lvar, Itree rhs,
                          int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
