package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * Itree of new_val('X' x 'Y' y).
 *
 * @param symValPairs sym-val pairs.
 * @param pos  the pos index of the itree.
 */
public record NoTraitNewValItree(List<SymValPair> symValPairs, int pos) implements Itree {

    /**
     * Constructs an itree of invocation in the form {@code new_val('X' x 'Y' y)}.
     *
     * @param symValPairs sym-val pairs.
     * @param pos  the pos index of the itree.
     */
    public NoTraitNewValItree {
        symValPairs = List.copyOf(symValPairs);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
