package org.kink_lang.kink.internal.program.itree;

import java.util.Set;

/**
 * Provides access to used/defined local vars in a fun.
 */
public interface UsedDefinedVars {

    /**
     * Returns the set of local vars used in the fun.
     *
     * @return the set of local vars used in the fun.
     */
    Set<LocalVar> usedLvars();

    /**
     * Returns the set of local vars defined in the fun.
     *
     * @return the set of local vars defined in the fun.
     */
    Set<LocalVar> definedLvars();

    /**
     * Returns the set of free local vars of the fun.
     *
     * @return the set of free local vars of the fun.
     */
    Set<LocalVar> freeLvars();

    /**
     * Whether the lvar is used in the fun.
     *
     * @param lvar the local var to test.
     * @return whether the lvar is used in the fun.
     */
    default boolean isUsed(LocalVar lvar) {
        return usedLvars().contains(lvar);
    }

    /**
     * Returns the content for the local var.
     *
     * @param lvar the local var.
     * @return the content for the local var.
     */
    LocalVarContent getContent(LocalVar lvar);

}

// vim: et sw=4 sts=4 fdm=marker
