package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.SeqItree;

/**
 * Flattens a seq recursively.
 *
 * <p>This optimizer itself does no good for performance,
 * but it enables further optimizations.</p>
 */
public class FlattenSeqOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(SeqItree seq) {
        List<Itree> steps = seq.steps().stream()
            .flatMap(itree ->
                itree instanceof SeqItree
                    ? ((SeqItree) itree).steps().stream()
                    : Stream.of(itree))
            .collect(Collectors.toList());
        return new SeqItree(steps, seq.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
