package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Supplier;

import org.kink_lang.kink.internal.program.itree.*;
import org.kink_lang.kink.internal.program.itreeoptimize.ssafy.SsaChecker;
import org.kink_lang.kink.internal.program.itreeoptimize.ssafy.Ssafier;

/**
 * Converts a fun to SSA form if possible.
 */
public class SsafyOptimizer extends BaseOptimizer {

    /** Supplier of unique strings. */
    private final Supplier<String> uniqSupplier;

    /**
     * Constructs an optimizer.
     *
     * @param uniqSupplier a supplier of unique strings.
     */
    public SsafyOptimizer(Supplier<String> uniqSupplier) {
        this.uniqSupplier = uniqSupplier;
    }

    @Override
    public Itree visit(SlowFunItree itree) {
        if (SsaChecker.canConvertToSsa(itree.body())) {
            var body = Ssafier.ssafy(itree.body(), this.uniqSupplier);
            return new FastFunItree(body, itree.pos());
        } else {
            return itree;
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
