package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.StoreItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;

/**
 * Optimizer from {@code B:X <- 42} to a STORE itree.
 */
public class StoreOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(AssignmentItree assignment) {
        Itree lhs = assignment.lhs();
        if (! (lhs instanceof VarrefItree)) {
            return assignment;
        }

        VarrefItree varref = (VarrefItree) lhs;
        return new StoreItree(
                varref.owner(),
                varref.sym(),
                assignment.rhs(),
                assignment.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
