package org.kink_lang.kink.internal.startup;

import java.util.List;
import java.util.stream.Collectors;

import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;

/**
 * The startup class of the Kink interpreter.
 */
public class Kink {

    /** The name of the startup mod; set mutable for test. */
    static String startupMod = "kink/_startup/STARTUP";

    /**
     * Must not be instantiated.
     */
    Kink() {
        throw new UnsupportedOperationException("must not be instantiated");
    }

    /**
     * Starts up the Kink interpreter.
     *
     * @param args the command line args.
     * @throws IllegalStateException when the Kink VM does not terminate normally.
     */
    public static void main(String... args) {
        Vm vm = Vm.newVm();
        VecVal argsVal = vm.vec.of(List.of(args).stream()
                .map(s -> vm.str.of(s))
                .collect(Collectors.toList()));
        RuntimeException rte = vm.run(
                c -> c.call(startupMod, vm.sym.handleFor("startup")).args(argsVal),
                v -> new RuntimeException("unexpected result: " + v.toString()),
                exc -> new RuntimeException(exc.toRuntimeException()));
        throw rte;
    }

}

// vim: et sw=4 sts=4 fdm=marker
