/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.vec.VecInternal;

class DataStack {
    private final Vm vm;
    private Val[] array;
    private final int maxCapa;
    private int sp;
    private int bp;

    DataStack(Vm vm, int initialCapa, int maxCapa) {
        this.vm = vm;
        this.array = new Val[initialCapa];
        this.maxCapa = maxCapa;
    }

    int sp() {
        return this.sp;
    }

    int bp() {
        return this.bp;
    }

    void increaseBp(int delta) {
        Preconds.checkPosIndex(delta, this.topOffset());
        this.bp += delta;
    }

    void decreaseBp(int delta) {
        Preconds.checkPosIndex(delta, this.bp);
        this.bp -= delta;
    }

    int topOffset() {
        return this.sp - this.bp;
    }

    Val[] backingArray() {
        return this.array;
    }

    private boolean ensureCapa(int minCapa) {
        if (this.array.length >= minCapa) {
            return true;
        }
        if (minCapa > this.maxCapa) {
            return false;
        }
        int newCapa = Math.min((int)((double)minCapa * 1.25), this.maxCapa);
        Val[] newArray = new Val[newCapa];
        System.arraycopy(this.array, 0, newArray, 0, this.sp);
        this.array = newArray;
        return true;
    }

    boolean ensureCapaSpPlus(int plus) {
        return this.ensureCapa(this.sp + plus);
    }

    Val atOffset(int offset) {
        Preconds.checkElemIndex(offset, this.topOffset());
        return this.array[this.bp + offset];
    }

    void setAtOffset(int offset, Val val) {
        Preconds.checkElemIndex(offset, this.topOffset());
        this.array[this.bp + offset] = val;
    }

    void push(Val val) {
        Preconds.checkState(this.sp < this.array.length, "not enough capa");
        this.array[this.sp] = val;
        ++this.sp;
    }

    void increaseSp(int count) {
        int newSp = this.sp + count;
        Preconds.checkArg(newSp <= this.array.length, "not enough capa");
        this.sp = newSp;
    }

    Val pop() {
        Preconds.checkState(this.sp >= 1, "no val to pop");
        --this.sp;
        Val popped = this.array[this.sp];
        this.array[this.sp] = null;
        return popped;
    }

    Val recv() {
        return this.atOffset(0);
    }

    @Nullable
    Val arg(int argIndex) {
        return this.atOffset(1 + argIndex);
    }

    VecVal argVec(int argCount) {
        int argStart = this.bp + 1;
        int argEnd = argStart + argCount;
        return this.vm.vec.of(this.array, argStart, argEnd);
    }

    void pushAll(Val[] vals) {
        Preconds.checkArg(this.sp + vals.length <= this.array.length, "not enough capa");
        System.arraycopy(vals, 0, this.array, this.sp, vals.length);
        this.sp += vals.length;
    }

    void pushAll(VecInternal vecInternal, int size) {
        Preconds.checkArg(this.sp + size <= this.array.length, "not enough capa");
        vecInternal.copyTo(this.array, this.sp, size);
        this.sp += size;
    }

    void removeToOffset(int offset) {
        int truncTo = this.bp + offset;
        Preconds.checkArg(truncTo <= this.sp, "too big offset");
        int moved = this.sp - truncTo;
        System.arraycopy(this.array, truncTo, this.array, this.bp, moved);
        int newSp = this.bp + moved;
        Arrays.fill(this.array, newSp, this.sp, null);
        this.sp = newSp;
    }

    void removeFromOffset(int offset) {
        int from = this.bp + offset;
        Preconds.checkArg(from <= this.sp, "too big offset");
        Arrays.fill(this.array, from, this.sp, null);
        this.sp = from;
    }

    VecVal makeVecFromOffset(int offset) {
        return this.vm.vec.of(this.array, this.bp + offset, this.sp);
    }

    Val[] slice(int from, int to) {
        Preconds.checkRange(from, to, this.sp);
        Val[] result = new Val[to - from];
        System.arraycopy(this.array, from, result, 0, to - from);
        return result;
    }

    Val[] sliceTop(int size) {
        return this.slice(this.sp - size, this.sp);
    }
}

