/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.TraceVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

public class ExceptionVal
extends Val {
    private final String message;
    private final List<TraceVal> traces;
    private final Optional<ExceptionVal> next;

    private ExceptionVal(Vm vm, String message, List<? extends TraceVal> traces, Optional<ExceptionVal> next) {
        super(vm);
        this.message = message;
        this.traces = List.copyOf(traces);
        this.next = next;
    }

    ExceptionVal(Vm vm, String message, List<? extends TraceVal> traces) {
        this(vm, message, traces, Optional.empty());
    }

    ExceptionVal(Vm vm, String message, List<? extends TraceVal> traces, ExceptionVal next) {
        this(vm, message, traces, Optional.of(next));
    }

    public String message() {
        return this.message;
    }

    public List<TraceVal> traces() {
        return this.traces;
    }

    public Optional<ExceptionVal> next() {
        return this.next;
    }

    public ExceptionVal chain(ExceptionVal tail) {
        ExceptionVal chained = tail;
        for (ExceptionVal head : this.fromBackToFront()) {
            chained = new ExceptionVal(this.vm, head.message(), head.traces(), chained);
        }
        return chained;
    }

    private List<ExceptionVal> fromBackToFront() {
        ArrayList<ExceptionVal> flattened = new ArrayList<ExceptionVal>();
        ExceptionVal exc = this;
        while (true) {
            flattened.add(exc);
            if (exc.next().isEmpty()) break;
            exc = exc.next().get();
        }
        Collections.reverse(flattened);
        return Collections.unmodifiableList(flattened);
    }

    public RuntimeException toRuntimeException() {
        RuntimeException rte = ExceptionVal.convertToRte(this);
        ExceptionVal parent = this;
        while (parent.next().isPresent()) {
            ExceptionVal suppressed = parent.next().get();
            rte.addSuppressed(ExceptionVal.convertToRte(suppressed));
            parent = suppressed;
        }
        return rte;
    }

    private static RuntimeException convertToRte(ExceptionVal exc) {
        ArrayList<TraceVal> myTraces = new ArrayList<TraceVal>(exc.traces());
        Collections.reverse(myTraces);
        List<StackTraceElement> stes = myTraces.stream().map(TraceVal::toStackTraceElement).toList();
        RuntimeException rte = new RuntimeException(exc.message());
        rte.setStackTrace((StackTraceElement[])stes.stream().toArray(StackTraceElement[]::new));
        return rte;
    }

    public String toString() {
        return String.format(Locale.ROOT, "ExceptionVal(%s %s)", this.message(), this.next());
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.exception.sharedVars;
    }

    private List<Object> properties() {
        return List.of(this.vm, this.message, this.traces, this.next);
    }

    public int hashCode() {
        return this.properties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof ExceptionVal)) return false;
        ExceptionVal argExc = (ExceptionVal)arg;
        if (!this.properties().equals(argExc.properties())) return false;
        return true;
    }
}

