/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.HashMap;
import java.util.Locale;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.LocationVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction1;

public final class LocationHelper {
    private final Vm vm;
    SharedVars sharedVars;

    LocationHelper(Vm vm) {
        this.vm = vm;
    }

    public LocationVal of(String programName, String programText, int charPos) {
        return new LocationVal(this.vm, programName, programText, charPos);
    }

    void init() {
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("program_name"), this.unaryOp("Loc.program_name", loc -> this.vm.str.of(loc.programName())));
        vars.put(this.vm.sym.handleFor("program_text"), this.unaryOp("Loc.program_text", loc -> this.vm.str.of(loc.programText())));
        vars.put(this.vm.sym.handleFor("pos"), this.unaryOp("Loc.pos", loc -> this.vm.num.of(loc.runePos())));
        vars.put(this.vm.sym.handleFor("line_num"), this.unaryOp("Loc.line_num", loc -> this.vm.num.of(loc.lineNum())));
        vars.put(this.vm.sym.handleFor("col_offset"), this.unaryOp("Loc.col_offset", loc -> this.vm.num.of(loc.columnRuneOffset())));
        vars.put(this.vm.sym.handleFor("col_num"), this.unaryOp("Loc.col_num", loc -> this.vm.num.of(loc.columnRuneOffset() + 1)));
        vars.put(this.vm.sym.handleFor("line"), this.unaryOp("Loc.line", loc -> this.vm.str.of(loc.line())));
        vars.put(this.vm.sym.handleFor("op_eq"), this.vm.fun.make("Loc.op_eq").take(1).action(c -> this.vm.bool.of(c.recv().equals(c.arg(0)))));
        vars.put(this.vm.sym.handleFor("repr"), this.unaryOp("Loc.repr", this::reprMethod));
        vars.put(this.vm.sym.handleFor("indicator"), this.unaryOp("Loc.indicator", loc -> this.vm.str.of(loc.indicator())));
        vars.put(this.vm.sym.handleFor("desc"), this.unaryOp("Loc.desc", loc -> this.vm.str.of(loc.desc())));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult reprMethod(LocationVal loc) {
        return loc.equals(this.of("", "", 0)) ? this.vm.str.of("(location empty)") : this.vm.str.of(String.format(Locale.ROOT, "(location %s)", loc.desc()));
    }

    private FunVal unaryOp(String prefix, ThrowingFunction1<LocationVal, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof LocationVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: Loc must be location, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply((LocationVal)recv);
        });
    }
}

