/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;

public class LocationVal
extends Val {
    private final String programName;
    private final String programText;
    private final int charPos;

    LocationVal(Vm vm, String programName, String programText, int charPos) {
        super(vm, null);
        Preconds.checkPosIndex(charPos, programText.length());
        this.programName = programName;
        this.programText = programText;
        this.charPos = charPos;
    }

    public String programName() {
        return this.programName;
    }

    public String programText() {
        return this.programText;
    }

    public int charPos() {
        return this.charPos;
    }

    public int runePos() {
        return this.programText.codePointCount(0, this.charPos());
    }

    public int lineNum() {
        int lineOffset = (int)this.programText().subSequence(0, this.charPos()).codePoints().filter(rune -> rune == 10).count();
        return lineOffset + 1;
    }

    public int columnCharOffset() {
        return this.charPos() - this.lineHeadCharIndex();
    }

    public int columnRuneOffset() {
        return this.programText().codePointCount(this.lineHeadCharIndex(), this.charPos());
    }

    public String line() {
        return this.programText().substring(this.lineHeadCharIndex(), this.lineTailCharIndex());
    }

    public String indicator() {
        String line = this.line();
        String before = line.substring(0, this.columnCharOffset());
        String after = line.substring(this.columnCharOffset());
        return String.format(Locale.ROOT, "%s-->%s", before, after).trim();
    }

    public String desc() {
        return String.format(Locale.ROOT, "%s L%d C%d", this.programName(), this.lineNum(), this.columnRuneOffset() + 1);
    }

    private int lineHeadCharIndex() {
        int lfInd = this.programText().lastIndexOf(10, this.charPos() - 1);
        return lfInd < 0 ? 0 : lfInd + 1;
    }

    private int lineTailCharIndex() {
        int lfInd = this.programText().indexOf(10, this.charPos());
        return lfInd < 0 ? this.programText().length() : lfInd + 1;
    }

    public String toString() {
        return String.format(Locale.ROOT, "LocationVal(%s L%d C%d)", this.programName, this.lineNum(), this.columnRuneOffset() + 1);
    }

    private List<Object> properties() {
        return List.of(this.vm, this.programName, this.programText, Integer.valueOf(this.charPos));
    }

    public int hashCode() {
        return this.properties().hashCode();
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof LocationVal && this.properties().equals(((LocationVal)arg).properties());
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.location.sharedVars;
    }
}

