/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.bootstrap.ConstBootstrapper;
import org.kink_lang.kink.internal.compile.javaclassir.ControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.NewVal;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.CondThenPair;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class OverriddenControlGenerator
implements ControlGenerator {
    private final Vm vm;
    private final String programName;
    private final String programText;
    private final KeyStrSupplier keySup;
    private final TraceAccumulator traceAccum;
    static final Handle BOOTSTRAP_PRELOADED_HANDLE = new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapPreloaded", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class).descriptorString(), false);
    static final Insn PRODUCE_NEW_VAL = new Insn.InvokeDynamic(MethodType.methodType(Val.class), BOOTSTRAP_PRELOADED_HANDLE, List.of("new_val"));

    public OverriddenControlGenerator(Vm vm, String programName, String programText, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
        this.keySup = keySup;
        this.traceAccum = traceAccum;
    }

    @Override
    public List<Insn> preloadedIf(IfItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<ItreeElem> args = new ArrayList<ItreeElem>(3);
        args.add(itree.cond());
        args.add(itree.trueFun());
        itree.falseFun().ifPresent(args::add);
        int pos = itree.pos();
        SymcallItree fallback = new SymcallItree(new LderefItree(new LocalVar.Original("if"), pos), "if", new NadaItree(pos), args, pos);
        return generate.apply(fallback, resultCtx);
    }

    @Override
    public List<Insn> branch(BranchItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        List<ItreeElem> args = this.condThenPairsToArgs(itree.condThenPairs());
        int pos = itree.pos();
        SymcallItree fallback = new SymcallItree(this.lderefBranch(pos), "branch", new NadaItree(pos), args, pos);
        return generate.apply(fallback, resultCtx);
    }

    @Override
    public List<Insn> branchWithElse(BranchWithElseItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<ItreeElem> args = new ArrayList<ItreeElem>(this.condThenPairsToArgs(itree.condThenPairs()));
        int pos = itree.pos();
        args.add(new LderefItree(new LocalVar.Original("true"), pos));
        args.add(itree.elseThenFun());
        SymcallItree fallback = new SymcallItree(this.lderefBranch(pos), "branch", new NadaItree(pos), args, pos);
        return generate.apply(fallback, resultCtx);
    }

    private LderefItree lderefBranch(int pos) {
        return new LderefItree(new LocalVar.Original("branch"), pos);
    }

    private List<ItreeElem> condThenPairsToArgs(List<CondThenPair> condThenPairs) {
        return condThenPairs.stream().flatMap(pair -> Stream.of(pair.condFun(), pair.thenFun())).toList();
    }

    @Override
    public List<Insn> traitNewVal(TraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        int pos = itree.pos();
        SymcallItree fallback = this.fallbackScallTraitNewVal(itree);
        String end = this.keySup.newKeyStr("end");
        ArrayList<Insn> insns = new ArrayList<Insn>(this.evalFallback(fallback, generate, resultCtx, pos, end));
        insns.addAll(NewVal.traitNewValCommonPart(this.vm, itree, generate, resultCtx, this.programName, this.programText, this.keySup, this.traceAccum));
        insns.addAll(resultCtx.returnOnTailOrMark(end));
        return insns;
    }

    @Override
    public List<Insn> noTraitNewVal(NoTraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        int pos = itree.pos();
        SymcallItree fallback = this.fallbackScallNoTraitNewVal(itree);
        String end = this.keySup.newKeyStr("end");
        ArrayList<Insn> insns = new ArrayList<Insn>(this.evalFallback(fallback, generate, resultCtx, pos, end));
        insns.addAll(NewVal.noTraitNewValCommonPart(this.vm, itree, generate, this.keySup));
        insns.addAll(resultCtx.returnOnTailOrMark(end));
        return insns;
    }

    private SymcallItree fallbackScallTraitNewVal(TraitNewValItree itree) {
        LderefItree newValLderef = new LderefItree(new LocalVar.Original("new_val"), itree.pos());
        ArrayList<ItreeElem> args = new ArrayList<ItreeElem>();
        args.add(new ItreeElem.Spread(itree.trait(), itree.spreadPos()));
        for (SymValPair symValPair : itree.symValPairs()) {
            args.add(new StrItree(symValPair.sym(), itree.pos()));
            args.add(symValPair.val());
        }
        return new SymcallItree(newValLderef, "new_val", new NadaItree(itree.pos()), args, itree.pos());
    }

    private SymcallItree fallbackScallNoTraitNewVal(NoTraitNewValItree itree) {
        LderefItree newValLderef = new LderefItree(new LocalVar.Original("new_val"), itree.pos());
        ArrayList<ItreeElem> args = new ArrayList<ItreeElem>();
        for (SymValPair symValPair : itree.symValPairs()) {
            args.add(new StrItree(symValPair.sym(), itree.pos()));
            args.add(symValPair.val());
        }
        return new SymcallItree(newValLderef, "new_val", new NadaItree(itree.pos()), args, itree.pos());
    }

    private List<Insn> evalFallback(SymcallItree fallback, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx, int pos, String end) {
        LderefItree newValLderef = new LderefItree(new LocalVar.Original("new_val"), pos);
        ArrayList<Insn> insns = new ArrayList<Insn>((Collection)generate.apply(newValLderef, ResultContext.NON_TAIL));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(PRODUCE_NEW_VAL);
        String intrinsicNewVal = this.keySup.newKeyStr("intrinsic-new_val");
        insns.add(new Insn.IfEq(Type.getType(Val.class), intrinsicNewVal));
        insns.addAll((Collection)generate.apply(fallback, resultCtx));
        if (!resultCtx.equals((Object)ResultContext.TAIL)) {
            insns.add(new Insn.GoTo(end));
        }
        insns.add(new Insn.Mark(intrinsicNewVal));
        return insns;
    }
}

