/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.program.itree.LocalVar;

public class SlowLvarAccessGenerator
implements LvarAccessGenerator {
    private final Vm vm;
    private final BindingGenerator bindingGen;
    private final KeyStrSupplier keySup;
    private final TraceAccumulator traceAccum;

    public SlowLvarAccessGenerator(Vm vm, BindingGenerator bindingGen, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        this.vm = vm;
        this.bindingGen = bindingGen;
        this.keySup = keySup;
        this.traceAccum = traceAccum;
    }

    @Override
    public List<Insn> loadLvar(LocalVar lvar, Location loc) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.loadLvarAllowNull(lvar));
        insns.addAll(LvarAccessGenerator.checkNull(lvar.name(), loc, this.keySup, this.traceAccum));
        return insns;
    }

    @Override
    public List<Insn> loadLvarAllowNull(LocalVar lvar) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.bindingGen.generateBinding());
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(Val.class, Val.class), InsnsGenerator.BOOTSTRAP_GET_VAR_HANDLE, List.of(Integer.valueOf(this.vm.sym.handleFor(lvar.name())))));
        insns.add(InsnsGenerator.STORE_CONTPARAM);
        return insns;
    }

    @Override
    public List<Insn> storeLvar(LocalVar lvar) {
        return this.setVar(lvar, List.of(InsnsGenerator.LOAD_CONTPARAM));
    }

    @Override
    public List<Insn> passRecv(LocalVar lvar) {
        return this.setVar(lvar, List.of(InsnsGenerator.LOAD_DATASTACK, InsnsGenerator.INVOKE_RECV));
    }

    @Override
    public List<Insn> passArg(LocalVar lvar, int argIndex) {
        return this.setVar(lvar, List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.PushInt(argIndex), InsnsGenerator.INVOKE_ARG));
    }

    private List<Insn> setVar(LocalVar lvar, List<Insn> content) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.bindingGen.generateBinding());
        insns.addAll(content);
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(Void.TYPE, Val.class, Val.class), InsnsGenerator.BOOTSTRAP_SET_VAR_HANDLE, List.of(Integer.valueOf(this.vm.sym.handleFor(lvar.name())))));
        return insns;
    }

    @Override
    public boolean isUnused(LocalVar lvar) {
        return false;
    }
}

