/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.kink_lang.kink.ExceptionVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.JavaHelper;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.mod.java.ProxyThrowResultVal;

public class JavaProxyMod {
    private final Vm vm;
    public static final String MOD_NAME = "kink/javahost/JAVA_PROXY";

    private JavaProxyMod(Vm vm) {
        this.vm = vm;
    }

    public static Val makeMod(Vm vm) {
        return new JavaProxyMod(vm).makeMod();
    }

    private Val makeMod() {
        Val mod = this.vm.newVal();
        mod.setVar(this.vm.sym.handleFor("new"), this.vm.fun.make("JAVA_PROXY.new(Intfs $handler)").take(2).action(this::newFun));
        return mod;
    }

    private HostResult newFun(CallContext c) throws ReflectiveOperationException {
        ClassLoader cl = this.getClass().getClassLoader();
        Val intfsVal = c.arg(0);
        if (!(intfsVal instanceof VecVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA_PROXY.new(Class_loader Intfs $handler): required a vec of interfaces for Intfs, but got {}", this.vm.graph.repr(intfsVal)));
        }
        List<Val> intfVals = ((VecVal)intfsVal).toList();
        Class[] interfaces = new Class[intfVals.size()];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> klass = this.extractClass(intfVals.get(i));
            if (klass == null) {
                return c.call(this.vm.graph.raiseFormat("JAVA_PROXY.new(Class_loader Intfs $handler): the #{} elem of Intfs is not a java val of class, but {}", this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(intfVals.get(i))));
            }
            interfaces[i] = klass;
        }
        Val handlerVal = c.arg(1);
        if (!(handlerVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA_PROXY.new(Class_loader Intfs $handler): required fun for $handler, but got {}", this.vm.graph.repr(handlerVal)));
        }
        InvocationHandler invHandler = this.makeInvocationHandler((FunVal)handlerVal);
        Object proxy = Proxy.newProxyInstance(cl, interfaces, invHandler);
        return this.vm.java.of(proxy, proxy.getClass());
    }

    @Nullable
    private Class<?> extractClass(Val val) {
        if (!(val instanceof JavaVal)) {
            return null;
        }
        Object obj = ((JavaVal)val).objectReference();
        if (!(obj instanceof Class)) {
            return null;
        }
        return (Class)obj;
    }

    private final VecVal toArgsVec(Method method, @Nullable Object[] args) {
        if (args == null) {
            return this.vm.vec.of();
        }
        Class[] paramTypes = method.getParameterTypes();
        List argVals = IntStream.range(0, args.length).mapToObj(i -> this.vm.java.of(args[i], paramTypes[i])).collect(Collectors.toList());
        return this.vm.vec.of(argVals);
    }

    private InvocationHandler makeInvocationHandler(FunVal fun) {
        return (proxy, method, args) -> {
            VecVal argsVal;
            JavaVal methodVal = this.vm.java.of(method, Method.class);
            ProxyResult result = (ProxyResult)((Object)this.vm.run(arg_0 -> JavaProxyMod.lambda$makeInvocationHandler$1(fun, methodVal, argsVal = this.toArgsVec(method, args), arg_0), Success::new, Failure::new));
            if (result instanceof Failure) {
                Failure failure = (Failure)result;
                throw new RuntimeException(failure.exception().toRuntimeException());
            }
            Val resultVal = ((Success)result).val();
            if (resultVal instanceof ProxyThrowResultVal) {
                ProxyThrowResultVal thrower = (ProxyThrowResultVal)resultVal;
                throw thrower.thrown();
            }
            return this.extractResult(method, resultVal);
        };
    }

    @Nullable
    private Object extractResult(Method method, Val resVal) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return null;
        }
        if (!(resVal instanceof JavaVal)) {
            throw new IllegalStateException("expected java val is returned, but was not");
        }
        JavaVal resJava = (JavaVal)resVal;
        Object resObj = resJava.objectReference();
        if (!JavaHelper.isTypable(resObj, returnType)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "unmatched result type of proxy fun for method \u00ab%s\u00bb, got %s", method, resObj));
        }
        return resObj;
    }

    private static /* synthetic */ HostResult lambda$makeInvocationHandler$1(FunVal fun, JavaVal methodVal, VecVal argsVal, CallContext c) throws Throwable {
        return c.call(fun).args((Val)methodVal, (Val)argsVal);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ProxyResult {
    }

    private record Failure(ExceptionVal exception) implements ProxyResult
    {
    }

    private record Success(Val val) implements ProxyResult
    {
    }
}

