/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.num;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.Val;

public final class NumOperations {
    NumOperations() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int hash(BigDecimal num) {
        if ((num = num.stripTrailingZeros()).scale() < 0) {
            num = num.setScale(0);
        }
        return num.hashCode();
    }

    public static int getElemIndex(BigDecimal num, int size) {
        if (num.scale() != 0) {
            return -1;
        }
        try {
            int intVal = num.intValueExact();
            return 0 <= intVal && intVal < size ? intVal : -1;
        }
        catch (ArithmeticException ex) {
            return -1;
        }
    }

    public static int getElemIndex(Val val, int size) {
        if (!(val instanceof NumVal)) {
            return -1;
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        return NumOperations.getElemIndex(dec, size);
    }

    public static int getPosIndex(BigDecimal num, int size) {
        if (num.scale() != 0) {
            return -1;
        }
        try {
            int intVal = num.intValueExact();
            return 0 <= intVal && intVal <= size ? intVal : -1;
        }
        catch (ArithmeticException ex) {
            return -1;
        }
    }

    public static int getPosIndex(Val val, int size) {
        if (!(val instanceof NumVal)) {
            return -1;
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        return NumOperations.getPosIndex(dec, size);
    }

    public static OptionalInt getExactInt(Val val) {
        if (!(val instanceof NumVal)) {
            return OptionalInt.empty();
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        if (dec.scale() != 0) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(dec.intValueExact());
        }
        catch (ArithmeticException ae) {
            return OptionalInt.empty();
        }
    }

    public static OptionalLong getExactLongBetween(Val val, long min, long max) {
        if (!(val instanceof NumVal)) {
            return OptionalLong.empty();
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        if (dec.scale() != 0) {
            return OptionalLong.empty();
        }
        try {
            long num = dec.longValueExact();
            return min <= num && num <= max ? OptionalLong.of(num) : OptionalLong.empty();
        }
        catch (ArithmeticException ae) {
            return OptionalLong.empty();
        }
    }

    public static BigInteger getExactBigInteger(Val val) {
        if (!(val instanceof NumVal)) {
            return null;
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        if (dec.scale() != 0) {
            return null;
        }
        return dec.toBigIntegerExact();
    }

    public static boolean isRangePair(BigDecimal from, BigDecimal to, int size) {
        if (from.scale() != 0 || to.scale() != 0) {
            return false;
        }
        try {
            int fromExact = from.intValueExact();
            int toExact = to.intValueExact();
            return 0 <= fromExact && fromExact <= toExact && toExact <= size;
        }
        catch (ArithmeticException ex) {
            return false;
        }
    }
}

