/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.Optional;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RecvArgsSearcher;

public class IfInliner
extends BaseOptimizer {
    @Override
    public Itree visit(SymcallItree scall) {
        if (!scall.isLocalCallOf("if")) {
            return scall;
        }
        if (scall.args().stream().anyMatch(ItreeElem::isSpread)) {
            return scall;
        }
        List<Itree> args = scall.args().stream().map(ItreeElem::expr).toList();
        if (args.size() < 2 || args.size() > 3) {
            return scall;
        }
        Itree cond = args.get(0);
        if (!this.isContFun(args.get(1))) {
            return scall;
        }
        FastFunItree trueCont = (FastFunItree)args.get(1);
        if (scall.args().size() == 2) {
            return new IfItree(cond, trueCont, Optional.empty(), scall.pos());
        }
        if (!this.isContFun(args.get(2))) {
            return scall;
        }
        FastFunItree falseCont = (FastFunItree)args.get(2);
        return new IfItree(cond, trueCont, Optional.of(falseCont), scall.pos());
    }

    private boolean isContFun(Itree itree) {
        FastFunItree fun;
        return itree instanceof FastFunItree && !RecvArgsSearcher.containsRecvOrArgs((fun = (FastFunItree)itree).body());
    }
}

