/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize.ssafy;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.kink_lang.kink.internal.program.itree.DeepTransformer;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;

public final class Ssafier {
    private Ssafier() {
    }

    public static Itree ssafy(Itree funBody, Supplier<String> uniqSupplier) {
        Callback callback = new Callback(uniqSupplier, Map.of());
        return DeepTransformer.deepTransform(funBody, callback);
    }

    static String noLvarGenerated() {
        throw new IllegalStateException("LocalVar.Generated must not be created");
    }

    public static class Callback
    implements DeepTransformer.Callback {
        private final Supplier<String> uniqSupplier;
        private final Map<LocalVar.Original, LocalVar> mapping;

        Callback(Supplier<String> uniqSupplier, Map<LocalVar.Original, LocalVar> mapping) {
            this.uniqSupplier = uniqSupplier;
            this.mapping = new HashMap<LocalVar.Original, LocalVar>(mapping);
        }

        @Override
        public LocalVar derefLvar(LocalVar lvar) {
            return this.mapping.getOrDefault(lvar, lvar);
        }

        @Override
        public LocalVar storeLvar(LocalVar lvar) {
            if (!(lvar instanceof LocalVar.Original)) {
                return lvar;
            }
            LocalVar.Original olv = (LocalVar.Original)lvar;
            LocalVar.Generated generated = new LocalVar.Generated(olv.name(), this.uniqSupplier.get());
            this.mapping.put(olv, generated);
            return generated;
        }

        @Override
        public Itree itree(Itree itree) {
            if (!(itree instanceof FastFunItree)) {
                return itree;
            }
            FastFunItree fun = (FastFunItree)itree;
            boolean overlaps = fun.freeLvars().stream().anyMatch(this.mapping::containsKey);
            if (!overlaps) {
                return itree;
            }
            Callback callback = new Callback(Ssafier::noLvarGenerated, this.mapping);
            Itree body = DeepTransformer.deepTransform(fun.body(), callback);
            return new FastFunItree(body, fun.pos());
        }
    }
}

