/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.vec;

import javax.annotation.CheckReturnValue;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.vec.MaybeTrait;
import org.kink_lang.kink.internal.vec.MutableVecInternal;
import org.kink_lang.kink.internal.vec.VecInternal;

public final class TraitVecInternal
extends VecInternal
implements MaybeTrait {
    private final SharedVars traitVars;

    TraitVecInternal(Vm vm, Val[] vals, SharedVars traitVars) {
        super(vm, vals, vals.length);
        this.traitVars = traitVars;
    }

    public SharedVars getTraitVars() {
        return this.traitVars;
    }

    @Override
    public TraitVecInternal getTrait() {
        return this;
    }

    @Override
    @CheckReturnValue
    public VecInternal set(int index, Val val) {
        Preconds.checkElemIndex(index, this.size());
        Val[] newVals = new Val[this.size()];
        this.copyTo(newVals, 0, this.size());
        newVals[index] = val;
        return new MutableVecInternal(this.vm, newVals, this.size());
    }

    @Override
    @CheckReturnValue
    public VecInternal remove(int index) {
        return this.removeRange(index, index + 1);
    }

    @Override
    @CheckReturnValue
    public VecInternal removeRange(int from, int to) {
        Preconds.checkRange(from, to, this.size());
        Val[] newVals = new Val[this.size() - (to - from)];
        this.copyOut(0, from, newVals, 0);
        this.copyOut(to, this.size() - to, newVals, from);
        return new MutableVecInternal(this.vm, newVals, this.size() - (to - from));
    }

    @Override
    @CheckReturnValue
    public VecInternal insert(int index, Val val) {
        Preconds.checkPosIndex(index, this.size());
        Val[] newVals = new Val[this.size() + 1];
        this.copyOut(0, index, newVals, 0);
        newVals[index] = val;
        this.copyOut(index, this.size() - index, newVals, index + 1);
        return new MutableVecInternal(this.vm, newVals, this.size() + 1);
    }

    @Override
    @CheckReturnValue
    public VecInternal insertAll(int index, VecInternal added) {
        Preconds.checkPosIndex(index, this.size());
        int addedSize = added.size();
        Val[] newVals = new Val[this.size() + addedSize];
        this.copyOut(0, index, newVals, 0);
        added.copyOut(0, addedSize, newVals, index);
        this.copyOut(index, this.size() - index, newVals, index + addedSize);
        return new MutableVecInternal(this.vm, newVals, this.size() + addedSize);
    }

    @Override
    @CheckReturnValue
    public VecInternal insertRange(int index, Val[] src, int from, int to) {
        Preconds.checkPosIndex(index, this.size());
        Preconds.checkRange(from, to, src.length);
        int addedSize = to - from;
        Val[] newVals = new Val[this.size() + addedSize];
        this.copyOut(0, index, newVals, 0);
        System.arraycopy(src, from, newVals, index, addedSize);
        this.copyOut(index, this.size() - index, newVals, index + addedSize);
        return new MutableVecInternal(this.vm, newVals, this.size() + addedSize);
    }
}

